
document.addEventListener("DOMContentLoaded",function(){
  var jsonEl=document.getElementById("decision-tree-data"); if(!jsonEl) return;
  var root=JSON.parse(jsonEl.textContent);
  function depth(n){if(!n)return 0;if(n.recommendation)return 1;if(n.options&&n.options.length){return 1+Math.max.apply(null,n.options.map(function(o){return depth(o.next||o);}));}return 1;}
  Vue.component("decision-tree",{
    data:function(){return{root:root,current:root,history:[],step:1,totalSteps:depth(root)}},
    methods:{
      choose:function(o){ if(o.next){this.history.push(this.current);this.current=o.next;this.step++;} else if(o.recommendation){this.history.push(this.current);this.current={recommendation:o.recommendation,link:o.link};this.step++;} },
      back:function(){ if(this.history.length){ this.current=this.history.pop(); this.step--; } },
      reset:function(){ this.current=this.root; this.history=[]; this.step=1; }
    },
    template:`<div>
      <div class="dt-progress" v-if="current.question">
        <p>Frage {{step}} von {{totalSteps}}</p>
        <div class="dt-progress-bar"><div class="dt-progress-fill" :style="{width:(step/totalSteps*100)+'%'}"></div></div>
      </div>
      <div v-if="current.question" class="dt-question">
        <h2>{{current.question}}</h2>
        <div class="dt-options">
          <div v-for="o in current.options" :key="o.text" @click="choose(o)" class="dt-card">{{o.text}}</div>
        </div>
      </div>
      <div v-else class="dt-recommendation">
        <h2>Empfehlung: {{current.recommendation}}</h2>
        <p v-if="current.link"><a :href="current.link" target="_blank" rel="noopener">Mehr erfahren</a></p>
      </div>
      <div class="dt-actions" v-if="step>1">
        <button class="dt-back-button" @click="back">Zurück</button>
        <button class="dt-reset-button" @click="reset">Neu starten</button>
      </div>
    </div>`
  });
  new Vue({el:"#decision-tree"});
});
